/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.items;

import com.alexander.mutantmore.entities.WitherBomb;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.renderers.items.WitherBombItemRenderer;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WitherBombItem
extends Item
implements IAnimatable {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public WitherBombItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult hitresult = WitherBombItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEventInit.WITHER_BOMB_THROW.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            if (!level.f_46443_) {
                WitherBomb bomb = new WitherBomb(level, (LivingEntity)player);
                bomb.setThrown(true);
                bomb.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -10.0f, 0.5f, 1.0f);
                bomb.setOwnerUUID(player.m_20148_());
                level.m_7967_((Entity)bomb);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        Vec3 vec3 = player.m_20252_(1.0f);
        double d0 = 5.0;
        List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec31)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            WitherBomb bomb = new WitherBomb(level, (LivingEntity)player);
            bomb.setThrown(false);
            bomb.setOwnerUUID(player.m_20148_());
            bomb.m_146922_(player.m_217043_().m_188503_(360));
            bomb.m_20219_(hitresult.m_82450_());
            if (!level.m_45756_((Entity)bomb, bomb.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!level.f_46443_) {
                level.m_7967_((Entity)bomb);
                level.m_220400_((Entity)player, GameEvent.f_157810_, hitresult.m_82450_());
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static void registerDispenseBehavior() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ItemInit.WITHER_BOMB.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level p_123485_, Position p_123486_, ItemStack p_123487_) {
                return (Projectile)Util.m_137469_((Object)((Object)new WitherBomb(p_123485_, p_123486_.m_7096_(), p_123486_.m_7098_(), p_123486_.m_7094_())), p_123483_ -> p_123483_.setThrown(true));
            }

            protected float m_7101_() {
                return super.m_7101_() * 0.75f;
            }

            protected float m_7104_() {
                return super.m_7104_() * 0.5f;
            }
        });
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("wither_bomb_item", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new WitherBombItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }
}

